function ModRnl=Fonc_ModulePartieRadiale(n,l,Z,X)
%
%   Cette fonction calcule la partie radiale R(n,l) d'un atome hydrognode, 
%   d'expression gnrale :
%
%   R(n,l)=
% 
%   Entres :   n       = nombre quantique principal
%               l       = moment cintique orbital (l<=n)
%   Sorties :   r       = Coordonne radiale
%               R(n,l)  = Partie Radiale
%
%   Attention : on garantit le calcul jusqu' n=30 --> A voir pour n>30 !
%
% Olivier Pujol : septembre 2013

%% Calcul du polynme associ de Laguerre L(n+l,2l+1)

PaLag=PolyAssoLaguerre(n,l,2*Z*X/n);    % Polynme associ de Laguerre

%% Calcul de la partie radiale R(n,l)

aB = 0.0529177E-9;  % Rayon de Bohr (m)

Facteur =(2*Z/(n*aB))^(1.5)*(gamma(n-l)/(2*n*(gamma(n+l+1))^3))^(0.5);

ModRnl=abs(-Facteur*(2*Z*X/n).^l.*exp(-Z*X/n).*PaLag);  % Partie radiale

return